SECTION "WRAM", ROM0[$DA80]

_EntryPoint:
    ;call VerifySaveFile
    call SwitchToSRA2
    ld a, [wOnSGB]
    ld [wOrigOnSGB], a
    jp _Start

wTextEngineVarsStart:
wTextEngineCurrentGlyph:
    ds 9
wTextEngineWorkingBlocks:
wTextEngineWorkingBlock1:
    ds 8
wTextEngineWorkingBlock2:
    ds 8
wTextEngineBoldFace:
    ds 1
wTextEngineCurrentXPosition:
    ds 1
wTextEngineCurrentCharIndex:
    ds 1
wTextEngineCurrentTilemapIndex:
    ds 1
wTextEngineVarsEnd:

wSerialKeyVarA:
    ds 1
wSerialKeyVarB:
    ds 1

wMenuCurrentSettings:
    ds 1
wMenuNumOptions:
    ds 1
wCurrentMapBank:
    ds 1
wCurrentMapNumber:
    ds 1
wCurrentMapWarp:
    ds 1
wCurrentWarpTargetX:
    ds 1
wCurrentWarpTargetY:
    ds 1
wOrigOnSGB:
    ds 1
wCurrentMapConnection:
    ds 1
wDMAHijackingEnabled:
    ds 1
wPreviousMapMusic:
    ds 1
wRAMScriptFillByte:
    ds 1
wTextBoxBank:
    ds 1
wTextBoxBufferPtr:
    ds 3
wTextBoxBufferListPtr:
    ds 3
wScriptVar:
    ds 1

wCurrentBattleCommand:
    ds 6

wTxNumBuf:
    ds 5

wPlayerXTile:
    ds 1
wPlayerYTile:
    ds 1
wPlayerSubPos:
    ds 1
wPlayerDir:
    ds 1
wPlayerFlags:
    ds 1 ; bit 0 - is walking
         ; bit 1 - is flipped
         ; bit 2 - bonk
wPlayerAnimTileCount:
    ds 1
wDrawSpriteInd:
    ds 1
wDrawSpritePos:
    ds 2
wDrawSpriteSize:
    ds 1
wDrawSpriteGraphic:
    ds 1
wDrawSpriteFlags:
    ds 1

wCameraXTile:
    ds 1
wCameraYTile:
    ds 1
wCameraXOff:
    ds 1
wCameraYOff:
    ds 1

wEventFlagGeneric:
    ds 1

wDebbieScreenX:
    ds 1
wDebbieScreenY:
    ds 1
wDebbieFlags
    ds 1 ; bit 0 - is walking
         ; bit 1 - is flipped

SwitchToSRA2:
    ld a, 2
SwitchToSRAX:
    ld [wCurrentSRAMBank], a
SwitchToSRAX_NoPreserve:
    ld [$4000], a
    ld a, $0a
    ld [$0000], a
    ret
SwitchToSRA3:
    ld a, 3
    jr SwitchToSRAX

wCurrentSRAMBank:
    ds 1

SafeCall:
    db $cd ; call
wSafeCallAddressLow:
    ds 1
wSafeCallAddressHigh:
    ds 1
RestoreAndReturn:
    ld a, [wCurrentSRAMBank]
    jr SwitchToSRAX
SafeCallHL:
    call .jp_hl
    jr RestoreAndReturn
.jp_hl
    jp hl

CopyDataFromSRAX:
    call SwitchToSRAX_NoPreserve
    call CopyData
    jr RestoreAndReturn

ReadFromSRA0:
    xor a
ReadFromSRAX:
    call SwitchToSRAX_NoPreserve
    ld a, [hl]
    push af
    call RestoreAndReturn
    pop af
    ret

;RecvExactWRAMDelegate:
;    xor a
;    call SwitchToSRAX_NoPreserve
;    ;ld a, [hl] ; stop on $ff in target buffer - protects against overflows
;    ;inc a
;    ;ret z
;.wait
;    ldh a, [$02]
;    bit 7, a
;    jr nz, .wait
;.received
;    ldh a, [$01]
;    xor e
;    ld [hli], a
;    ld a, 2
;    call SwitchToSRAX_NoPreserve
;    dec bc
;    ld a, c
;    or b
;    jp nz, RecvExact
;    ret

StandardTextboxDelegate:
    db 8 ; TX_ASM
    call SwitchToSRA2
    	;call RunNPCScript
    jp TextScriptEnd

DetermineCurrentSRABank:
    ld a, [_SRA2Ident]
    cp 2
    ret z
    cp 3
    ret z
    xor a
    ret

CommonMapScr:
    ret

DMAHijackingRoutine:
    ;add sp, 12
    ;pop de
    ;ld hl, wDMAHijackingReturnAddress
    ;ld [hl], e
    ;inc hl
    ;ld [hl], d
    ;ld hl, DMAHijackingReturn
    ;push hl
    ;add sp, -12

    ld hl, $FF40
    set 1, [hl]

    xor a
    ldh [$FFF8], a

    ldh a, [$FF8A]	; disable soft reset
    cp $10
    jr nc, .noUndo
    ld a, $10
    ldh [$FF8A], a
    ldh [$FFF8], a	; i have to do a bunch of weird shit cause gamefreak cant code for fuck and the vanilla soft reset code causes a memory leak if it lasts too long
    xor a
    ldh [$FFF5], a
.noUndo

    ld a, $c3
    ld c, $46
    ret

DMAHijackingReturn:
    ;push af
    ;push bc
    ;push de
    ;push hl
    ;ld a, [wDMAHijackingEnabled]
    ;and a
    ;jr z, .disabled
    ;call DetermineCurrentSRABank
    ;push af
    ;ld a, 2
    ;call SwitchToSRAX_NoPreserve
    ;call DMAHijackingProc
    ;pop af
    ;call SwitchToSRAX_NoPreserve
.disabled
    ;pop hl
    ;pop de
    ;pop bc
    ;pop af
    ;db $c3 ; jp
wDMAHijackingReturnAddress:
    ;ds 2

LoadMisfortuneGraphics:     ;BlackHairBoy1Sprite
    call SwitchToSRA3
    lb bc, b_BlackHairBoy1Sprite, 24
    ;ld de, MisfortuneGraphics ; A7DD
    ld de, BlackHairBoy1Sprite
    ld hl, $8000
    call CopyVideoData ; DB6F
    
    ld de, SpriteGfx
    ld c, 30 ; 28
    ld hl, $8180
    call CopyVideoData
    
    ;ld c, 80
    ;ld de, GameOverGfx
    ;ld hl, $8800
    ;call CopyVideoData
    
    ld c, 176
    ld de, WorldGfx
    ld hl, $8800
    call CopyVideoData

    call SwitchToSRA2
    ret

LoadGameOverGfx:
    call SwitchToSRA3
    ld c, 80
    ld de, GameOverGfx
    ld hl, $8820
    call CopyVideoData
    jp SwitchToSRA2

ResetPalettes:
    ld hl, FadePal5
    ld a, [hli]
    ld [rBGP], a
    ld a, [hli]
    ld [rOBP0], a
    ld a, [hli]
    ld [rOBP1], a
    call UpdateGBCPal_BGP
    call UpdateGBCPal_OBP0
    call UpdateGBCPal_OBP1
    ret

NoSignData:
NoWarpData:
NoEventData:
NoObjects:
    db $00
NoLoadScript:
    ret

include "include/sfx.asm"
    