SECTION "SRA2", ROM0[$A000]

_SRA2Checksum:
    ds 1

_SRA2Ident:
    db 2
include "engine/utils.asm"
include "engine/dma_hijacking.asm"

MapScriptLoad:
    jp DMAHijackingApply

MapScriptPokemonTowerTop:
    ld a, $4C
    ld [$C730],a
    xor a
    ld [wGrassRate], a
    ld a, [wYCoord]
    cp a, $03
    ret nz
    ld a, $FF
    ld [wAudioFadeOutControl], a
    ld c, 50
    call DelayFrames


    ld hl, WinText
    ld de, LoseText
    call SaveEndBattleTextPointers

    ld a, 9
    ld [wGymLeaderNo], a

    ld a, $EE	;$E1
    ld [$D059], a
    	;ld [wEngagedTrainerClass], a

    ld hl, wd72d
    set 7, [hl]

    call LoaderTextbox
    ld hl, IntroText
    call PrintTextNew

    
    ret


;DecompressAndLoadSpriteFromBuffer:
;    ld a, b_RedPicFront
;    ld de, wTileMapBackup ;CompressedPicBuffer
;    ld hl, wSafeCallAddressLow
;    ld [hl], LOW(UncompressSpriteFromDE)
;    inc hl
;    ld [hl], HIGH(UncompressSpriteFromDE)
;    call SafeCall
;
;    ld de, $9000	;vFrontPic
;    ld a, $77
;    ld c, a
;    ld hl, wSafeCallAddressLow
;    ld [hl], LOW(LoadUncompressedSpriteData)
;    inc hl
;    ld [hl], HIGH(LoadUncompressedSpriteData)
;    jp SafeCall
;    ret

GameOver:

    ld a, $FF
    call PlaySound

    ld b, SET_PAL_BATTLE_BLACK
    call RunPaletteCommand

    call GBFadeOutToBlack
    
    coord hl, 0, 0
    ld bc, SCREEN_WIDTH*$12
    ld a, $7F
    call FillMemory

    coord hl, 0, 12
    lb bc, $04, $12
    call TextBoxBorder

    coord hl, 5, 14
    ld de, GameOverString
    call PlaceString

    ld de, wTileMapBackup ;CompressedPicBuffer
    ld hl, GameOverPic
    ld bc, BurymanParty-GameOverPic
    ld a, 3
    call CopyDataFromSRAX
    call DecompressAndLoadSpriteFromBuffer

    ld b, SET_PAL_GENERIC
    call RunPaletteCommand

    xor a
    ldh [$FFE1], a    ; hStartTileID
    coord hl, 6, 4
    predef CopyUncompressedPicToTilemap
    call Delay3

    call GBFadeInFromBlack

    	;ld a, MUSIC_LAVENDER
    	;ld c, $02			;BANK(Music_Lavender)
    	;call PlayMusic

    ld a, $02
    call BankswitchHome

    ld de, $c9e0
    ld bc, Music_LavenderReverse_End - Music_LavenderReverse
    ld hl, Music_LavenderReverse
    ld a, 3
    call CopyDataFromSRAX
    ld de, $c9d0
    ld bc, 8
    ld hl, Music_LavenderReverse_Pointers
    ld a, 3
    call CopyDataFromSRAX
    ld hl, $c9d0
    call PlayMusicFromRAM

    call WaitForTextScrollButtonPress

    ld a, $FF
    ld [wAudioFadeOutControl], a

    call GBFadeOutToBlack

    ld c, 30
    call DelayFrames

    jp SoftReset

IntroText:
	text "You're... Here."

	para "I'm trapped..."

	para "And I'm lonely..."
	line "So very lonely..."

	para "Won't you join me?"
        done

LoseText:
	text "BURIEDALIVE:"
        line "Finally,"
	cont "fresh meat!"

        para "ちゃんと　した　しょくじを"
	line "するのは　ひさしぶり　だ　な"

	para "まいにち　まいばん"
	line "まっていたんだ"

	para "そして　ついに　うでのなかに"
	line "しょくじ　が　はいってきた"

	para "なんて　すてきな"
	line "しょくじ　に　なるんだろう！"

	para "そのした　そのかんぞう"
	line "そのしんぞう<……>"

	para "とても　わかく"
	line "とても　じゅくしている！"

	para "そして　それはすべて"
	line "わたしが　たべるための　もの！"

	para "ぼうや　こっちにおいで"
	line "とても　おなかが　すいている"

	para "<……> いただきます<……>!"
        prompt

GameOverString:
	db "GAME OVER.@"

PrintTextNew:
    push hl 
    ld a,$01
    ld [$FF8C], a		;[hSpriteIndex], a
    farcall DisplayTextIDInit
    pop hl
    call PrintText
    call WaitForTextScrollButtonPress
    jp CloseTextDisplay