; overworld.asm

TileDefinitions:
include "include/tileset.asm"

DIR_UP equ $01
DIR_DOWN equ $02
DIR_LEFT equ $03
DIR_RIGHT equ $04

; draw tile a at hl
DrawTile:
    push hl
    ld hl, TileDefinitions
    ld bc, $0004
    call AddNTimes	; pointer to tile data stored at hl
    pop de

    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hli]
    ld [de], a
    push hl
    push de
    pop hl
    ld bc, $0020 - 1
    add hl, bc
    push hl
    pop de
    pop hl
    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hl]
    ld [de], a
    ret

M_OverworldInit:
    xor a
    ld [wUpdateSpritesEnabled], a


    ld a, $01
    ld [wPlayerDir], a

    ; fall through (probably)

M_OverworldLoop:


    ; get input
    ld a, [wPlayerFlags]
    bit 0, a
    jp nz, .walkPlayer
    call JoypadLowSensitivity
    ld a, [$FFB4] ;hJoy5
    and %11110001 ; dont care about start, select, or b
    and a
    jr z, .noInput
    bit 7, a
    jr nz, .downPressed
    bit 6, a
    jr nz, .upPressed
    bit 5, a
    jr nz, .leftPressed
    bit 4, a
    jr nz, .rightPressed
    jr .noInput
    
.upPressed
    ld a, DIR_UP
    ld [wPlayerDir], a
    jr .startWalk
.downPressed
    ld a, DIR_DOWN
    ld [wPlayerDir], a
    jr .startWalk
.leftPressed
    ld a, DIR_LEFT
    ld [wPlayerDir], a
    jr .startWalk
.rightPressed
    ld a, DIR_RIGHT
    ld [wPlayerDir], a
.startWalk

    ld a, [wPlayerFlags]
    set 0, a
    ld [wPlayerFlags], a
    
.noInput

    ; update voam (every frame?)
    	;ld a, [wPlayerYTile]
    	;ld [wOAMBuffer], a
    	;ld a, [wPlayerXTile]
    	;ld [wOAMBuffer+1], a
    ld a, [wPlayerYTile]
    call MultBy8
    ld c, a
    ld a, [wPlayerXTile]
    call MultBy8
    ld b, a
    
    ld a, [wPlayerSubPos]
    ld d, a
    ld a, [wPlayerFlags]
    bit 0, a
    jr z, .noWalk
    ld a, [wPlayerDir]
    dec a
    jr z, .walkUpOffs
    dec a
    jr z, .walkDownOffs
    dec a
    jr z, .walkLeftOffs
.walkRightOffs
    ld a, b
    add d
    ld b, a
    jr .noWalk
.walkUpOffs
    ld a, c
    sub d
    ld c, a
    jr .noWalk
.walkDownOffs
    ld a, c
    add d
    ld c, a
    jr .noWalk
.walkLeftOffs
    ld a, b
    sub d
    ld b, a
    jr .noWalk
.noWalk
    xor a
    ld hl, wDrawSpriteInd
    ld [hli], a		; index

    ld a, b		; pos
    ld [hli], a
    ld a, c
    ld [hli], a

    ld a, $22		; size
    ld [hli], a

    call CalcPlayerFrame

    ld [hli], a		; graphic
    ld a, [wPlayerFlags]
    ld [hl], a		; flags
    
    call DrawSprite_M
    
    call DelayFrame
    
    jp M_OverworldLoop

.walkPlayer ; a = wPlayerDir
    ld a, [wPlayerSubPos]
    cp 7
    jr z, .walkDone
    inc a
    ld [wPlayerSubPos], a
    jp .noInput

.walkDone
    ld a, [wPlayerDir]
    dec a
    jr z, .finUp
    dec a
    jr z, .finDown
    dec a
    jr z, .finLeft
.finRight
    ld a, [wPlayerXTile]
    inc a
    ld [wPlayerXTile], a
    jr .walkDoneDone
.finUp
    ld a, [wPlayerYTile]
    dec a
    ld [wPlayerYTile], a
    jr .walkDoneDone
.finDown
    ld a, [wPlayerYTile]
    inc a
    ld [wPlayerYTile], a
    jr .walkDoneDone
.finLeft
    ld a, [wPlayerXTile]
    dec a
    ld [wPlayerXTile], a
.walkDoneDone
    ld a, [wPlayerAnimTileCount]
    inc a
    ld [wPlayerAnimTileCount], a
    xor a
    ld [wPlayerSubPos], a
    ld a, [wPlayerFlags]
    and %11111110
    ld [wPlayerFlags], a
    jp .noInput

; wDrawSpriteInd - wDrawSpriteFlags
DrawSprite_M:
    ld hl, wOAMBuffer		; ld hl with first sprite addr
    ld bc, $4
    ld a, [wDrawSpriteInd]
    call AddNTimes
    ld a, [wDrawSpriteSize]
    push af			; ld de with size
    and a, %00001111
    ld e, a
    pop af
    ;rra
    ;rra
    ;rra
    ;rra
    and a, %00001111
    ld d, a
    	;ld a, [wDrawSpriteFlags]	; ld c with flags
    	;ld c, a
    ld a, [wDrawSpritePos]		; ld bc with pos
    ld b, a
    ld a, [wDrawSpritePos+1]
    ld c, a

    push de

    ld a, [wDrawSpriteFlags]
    bit 1, a
    jr nz, .drawFlipped

.colLoop
    push bc
.rowLoop
    ld a, c
    ld [hli], a
    ld a, b
    ld [hli], a
    ld a, [wDrawSpriteGraphic]
    ld [hli], a
    inc a
    ld [wDrawSpriteGraphic], a
    xor a
    ld [hli], a
    ld a, 8
    add a, b
    ld b, a
    dec d
    jr nz, .rowLoop
    pop bc
    dec e
    jr z, .done
    ld a, e
    pop de
    push de
    ld e, a
    ld a, 8
    add a, c
    ld c, a
    jr .colLoop
.done
    pop de
    ret

.drawFlipped

.colLoop_f
    push bc
    ld a, d
    call MultBy4
    add b
    ld b, a
.rowLoop_f
    ld a, c
    ld [hli], a
    ld a, b
    ld [hli], a
    ld a, [wDrawSpriteGraphic]
    ld [hli], a
    inc a
    ld [wDrawSpriteGraphic], a
    ld a, $20
    ld [hli], a
    ld a, b
    sub 8
    ld b, a
    dec d
    jr nz, .rowLoop_f
    pop bc
    dec e
    jr z, .done
    ld a, e
    pop de
    push de
    ld e, a
    ld a, 8
    add a, c
    ld c, a
    jr .colLoop_f
    ret
    
MultBy8:
    push bc
    ld c, 7
MultByC_PopBC
    ld b, a
.loop
    add b
    dec c
    jr nz, .loop
    pop bc
    ret
MultBy6:
    push bc
    ld c, 5
    jr MultByC_PopBC
MultBy4:
    push bc
    ld c, 3
    jr MultByC_PopBC
    
CalcPlayerFrame:
    ld a, [wPlayerFlags]
    res 1, a
    ld [wPlayerFlags], a
    ld a, [wPlayerDir]
    dec a
    jr z, .up
    dec a
    jr z, .down
    dec a
    jr z, .left
    ld a, [wPlayerFlags]
    set 1, a
    ld [wPlayerFlags], a
.left
    ld a, 8
    jr .walkCheck
.up
    ld a, 4
    jr .walkCheck
.down
    xor a

.walkCheck
    ld b, a
    ld a, [wPlayerSubPos]
    cp 4
    jr c, .notWalking
    ld a, b
    add a, $0C
    ld b, a
    ld a, [wPlayerDir]
    cp 3
    jr nc, .notWalking
    ld a, [wPlayerAnimTileCount]
    bit 0, a
    jr z, .notWalking
    ld a, [wPlayerFlags]
    set 1, a
    ld [wPlayerFlags], a
.notWalking
    ld a, b
    ret
    
    

    