
CHAR_DEFINITION_SIZE equ 9
CHAR_TILE_BUFFER_SIZE equ 96   ;36

InitTextEngine:
    ld bc, wTextEngineVarsEnd - wTextEngineVarsStart
    ld hl, wTextEngineVarsStart
    xor a
    jp FillMemory

ClearWorkingBlocks:
    ld bc, 16
    ld hl, wTextEngineWorkingBlocks
    xor a
    jp FillMemory

PrintTextVWF:
    ld a, 2
PrintTextVWF_Banked:
    ld [wTextBoxBank], a
    push hl
    call InitTextEngine
    	;ld a, 1
    	;ld [wTextBoxID], a
    	;call DisplayTextBoxID	; todone: ld 5A to hwy
    call DrawTextBox
    ld a, $5A
    ldh [$FFB0], a
    ld a, $9C
    ldh [$FFBD], a
    ldh [$FFBA], a
    pop hl
PrintTextVWFCommandProcessor:

    call M_HideSprites

    ld a, [wTextBoxBank]
    call ReadFromSRAX
    inc hl
    and a
    jr z, .done
    cp $f0
    jr nc, .command
    call PrintSingleChar
    jr PrintTextVWFCommandProcessor
.done

    	;ld a, $90
    	;ldh [$FFB0], a
    	;xor a
    	;ldh [$FFBA], a
    

    ld de, wTextBoxBufferPtr + 2
    ld a, [de]
    and a
    jr z, .close
.exitBuffer
    ld h, a
    xor a
    ld [de], a
    dec de
    ld a, [de]
    ld l, a
    dec de
    ld a, [de]
    ld [wTextBoxBank], a
    jr PrintTextVWFCommandProcessor
.command
    sub $f0
    ld c, a
    ld b, 0
    push hl
    ld hl, VWFCommandsJumptable
    add hl, bc
    add hl, bc
    ld a, [hli]
    ld d, [hl]
    ld e, a
    pop hl
    push de
    ret
.close
    call RotateBlocks
    jp CloseTextBox

VWFCommandsJumptable:
    dw 0 ; ??
    dw TextCommandF1
    dw TextCommandF2
    dw TextCommandF3
    dw TextCommandF4
    dw TextCommandF5
    dw TextCommandF6
    dw TextCommandF7
    dw TextCommandF8
    dw TextCommandF9
    dw TextCommandFA
    dw TextCommandFB
    dw TextCommandFC
    ; todo
    
TextCommandF1:
    push hl
    call RotateBlocks
    call WaitButtonPress
    call ScrollTextUpOneLine
    call ScrollTextUpOneLine
    ld a, SCREEN_WIDTH * 2
    ld [wTextEngineCurrentTilemapIndex], a
    xor a
    ld [wTextEngineCurrentXPosition], a
    pop hl
    jr PrintTextVWFCommandProcessor

TextCommandF2:
    push hl
    call RotateBlocks
    call ClearWorkingBlocks
    ld a, [wTextEngineCurrentTilemapIndex]
;    cp SCREEN_WIDTH		; v hacky but whatever im tired
;    jr nc, .thirdline
;.secondline
;    ld a, SCREEN_WIDTH		; * 2
;    jr .cont
;.thirdline
;    ld a, SCREEN_WIDTH * 2
    ld b, a
    ld a, SCREEN_WIDTH
.loop
    cp b
    jr nc, .cont
    add a, SCREEN_WIDTH
    jr .loop
.cont
    ld [wTextEngineCurrentTilemapIndex], a
    xor a
    ld [wTextEngineCurrentXPosition], a
    pop hl
    jp PrintTextVWFCommandProcessor

TextCommandF3:
    push hl
    call RotateBlocks
    call WaitButtonPress
    call ClearWorkingBlocks
    xor a
    ld [wTextEngineCurrentXPosition], a
    ld [wTextEngineCurrentCharIndex], a
    ld [wTextEngineCurrentTilemapIndex], a
    coord hl, 1, 1 ; 13
    ld bc, $0512
    call ClearScreenArea
    ld c, 16
    call DelayFrames
    pop hl
    jp PrintTextVWFCommandProcessor

TextCommandF4:
    push hl
    call RotateBlocks
    call WaitButtonPress
    pop hl
    jp PrintTextVWFCommandProcessor

TextCommandF5:
    ld a, 1
    ld [wTextEngineBoldFace], a
    jp PrintTextVWFCommandProcessor

TextCommandF6:
    xor a
    ld [wTextEngineBoldFace], a
    jp PrintTextVWFCommandProcessor

SaveCurrentTextboxBuffer:
    ld de, wTextBoxBufferPtr
    ld a, [wTextBoxBank]
    ld [de], a
    ld b, a
    inc de
    ld a, l
    ld [de], a
    inc de
    ld a, h
    ld [de], a
    ret

TextCommandF7:
    inc hl
    inc hl
    inc hl
    call SaveCurrentTextboxBuffer
    dec hl
    dec hl
    dec hl ; yeah yeah spare me the notlikethis
    ld a, b
    call ReadFromSRAX
    inc hl
    ld [wTextBoxBank], a
    ld a, b
    call ReadFromSRAX
    inc hl
    ld c, a
    ld a, b
    call ReadFromSRAX
    ld l, c
    ld h, a
    jp PrintTextVWFCommandProcessor

TextCommandF8:
    ; text buffer from ID
    ld a, [wTextBoxBank]
    call ReadFromSRAX
    ld c, a
    inc hl
    call SaveCurrentTextboxBuffer
TextCommandF8_PrintNthTextBuffer:
    ld hl, wTextBoxBufferListPtr
    ld a, [hli]
    ld b, a
    ld a, [hli]
    ld h, [hl]
    ld l, a
    ld a, c
    and a
    jr z, .found
.findNthEntry
    ld a, b
    call ReadFromSRAX
    inc hl
    and a
    jr nz, .findNthEntry
.goNext
    dec c
    jr nz, .findNthEntry
.found
    ld a, b
    ld [wTextBoxBank], a
    jp PrintTextVWFCommandProcessor

TextCommandF9:
    ; text buffer from ID indirect
    ld a, [wTextBoxBank]
    call ReadFromSRAX
    ld c, a
    inc hl
    call SaveCurrentTextboxBuffer
    ld b, 0
    ld hl, wCurrentBattleCommand
    add hl, bc
    ld c, [hl]
    jr TextCommandF8_PrintNthTextBuffer

TextCommandFA:
    ; print 16-bit number from address
    ld a, [wTextBoxBank]
    call ReadFromSRAX
    ld e, a
    inc hl
    ld a, [wTextBoxBank]
    call ReadFromSRAX
    ld d, a
    ld a, [de]
    ld b, a
    inc de
    ld a, [de]
    ld c, a
    inc hl
    push bc
    call SaveCurrentTextboxBuffer
    pop bc
    ld de, wTxNumBuf
    ld a, b
    swap a
    and $0f
    add "0"
    ld [de], a
    inc de
    ld a, b
    and $0f
    add "0"
    ld [de], a
    inc de
    ld a, c
    swap a
    and $0f
    add "0"
    ld [de], a
    inc de
    ld a, c
    and $0f
    add "0"
    ld [de], a
    inc de
    xor a
    ld [de], a
.removeLeadingZeros
    ld hl, wTxNumBuf
    ld a, [hli]
    cp "0"
    jr nz, .noLeadingZero
    ld a, [hld]
    ld [hli], a
    inc hl
    ld a, [hld]
    ld [hli], a
    inc hl
    ld a, [hld]
    ld [hli], a
    inc hl
    ld a, [hld]
    ld [hl], a
    jr .removeLeadingZeros
.noLeadingZero
    ld hl, wTxNumBuf
    and a
    jr nz, .completeZero
    ld [hl], "0"
    inc hl
    ld [hld], a
.completeZero
    jp PrintTextVWFCommandProcessor

TextCommandFB:
    ; delay frames
    ld a, [wTextBoxBank]
    call ReadFromSRAX
    inc hl
    push af
    push hl
    call RotateBlocks
    pop hl
    pop af
    ld c, a
    call DelayFrames
    jp PrintTextVWFCommandProcessor

WaitButtonPress:
    push hl
    coord hl, 18, 17
    ld b, 0
.loop
    push bc
    call DelayFrame_HideSprites
    call JoypadLowSensitivity
    pop bc
    ldh a, [$b5]
    and 3
    jr nz, .finish
    inc b
    ld a, b
    and $10
    jr z, .arrow
    ;ld [hl], $7a
    jr .loop
.arrow
    ;ld [hl], $ee
    jr .loop
.finish
    ;ld [hl], $7a
    pop hl
    ;ld a, $90
    ;jp PlaySound
    ret

TextCommandFC:
    ; cls without button press
    push hl
    call RotateBlocks
    call ClearWorkingBlocks
    xor a
    ld [wTextEngineCurrentXPosition], a
    ld [wTextEngineCurrentCharIndex], a
    ld [wTextEngineCurrentTilemapIndex], a
    coord hl, 1, 13
    ld bc, $0412
    call ClearScreenArea
    ld c, 16
    call DelayFrames
    pop hl
    jp PrintTextVWFCommandProcessor

PrintSingleChar:
    push hl
    ld bc, CHAR_DEFINITION_SIZE
    ld hl, CharacterSet
    dec a
    call AddNTimes
    ld de, wTextEngineCurrentGlyph
    ld bc, 9
    ld a, 3
    call CopyDataFromSRAX
    ld hl, wTextEngineCurrentGlyph
    call CopyCharToWorkingBlocks
    pop hl
    ret

CopyCharToWorkingBlocks:
    ld a, [hli]
    push af
    ld a, [wTextEngineBoldFace]
    and a
    jr z, .noBold
    pop af
    inc a
    push af
.noBold
    ld a, 8
    ld de, wTextEngineWorkingBlock1
.eachByte
    call RotateAndCopySingleLine
    inc hl
    inc de
    dec a
    jr nz, .eachByte
    ld a, [wTextEngineCurrentXPosition]
    ld b, a
    pop af
    add b
    inc a
    cp 8
    call nc, RotateBlocks
    and 7
    ld [wTextEngineCurrentXPosition], a
    ret

RotateBlocks:
    push af
    ld hl, $91F0 ;orig. $8bb0
    ld bc, $0010
    ld a, [wTextEngineCurrentCharIndex]
    inc a
    cp CHAR_TILE_BUFFER_SIZE
    jr c, .noOverflow
    sub CHAR_TILE_BUFFER_SIZE
.noOverflow
    ld [wTextEngineCurrentCharIndex], a
    call AddNTimes
    ld de, wTextEngineWorkingBlocks
    call UpdateVRAMAndDelayFrame
    ld bc, 8
    ld hl, wTextEngineWorkingBlock2
    ld de, wTextEngineWorkingBlock1
    call CopyData
    ld hl, wTextEngineCurrentTilemapIndex
    inc [hl]
    pop af
    ret

RotateAndCopySingleLine:
    push af
    push de
    push hl
    ld b, [hl]
    ld a, [wTextEngineBoldFace]
    and a
    ld a, b
    jr z, .noBold
    srl b
    or b
.noBold
    ld b, a
    ld c, 0
    ld a, [wTextEngineCurrentXPosition]
.shiftATimes
    and a
    jr z, .isZero
    rr b
    rr c
    dec a
    jr .shiftATimes
.isZero
    ld h, d
    ld l, e
    ld de, 8
    ld a, b
    or [hl]
    ld [hl], a
    add hl, de
    ld [hl], c
    pop hl
    pop de
    pop af
    ret

UpdateVRAMAndDelayFrame:
    di
    ld c, 8
.waitHblank
    ldh a, [rSTAT]
    and %00000011
    jr nz, .waitHblank
    ld a, [de]
    ld [hli], a
    ld [hli], a
    inc de
.waitNoHblank
    ldh a, [rSTAT]
    and %00000011
    jr z, .waitNoHblank
    dec c
    jr nz, .waitHblank
.recalc
    coord hl, 1, 1 ;13   ; 14
    ld a, [wTextEngineCurrentTilemapIndex]
    ld b, 0
    ld c, a
    add hl, bc
    ld a, h
    cp $c5
    jr c, .ok
    xor a
    ld [wTextEngineCurrentTilemapIndex], a
    jr .recalc
.ok
    ld a, [wTextEngineCurrentCharIndex]
    add $1F   ; orig. $bb
    ld [hl], a
    ;ld a, $7c; $7c
    ;ld [$c4f3], a
    ;ld [$c4cb], a
    ei
    jp DelayFrame_HideSprites

DrawTextBox:
    xor a
    ldh [$FFBB], a    ;H_AUTOBGTRANSFERPORTION
    

    coord hl, $00, $00 ; $0B
DrawTextBoxAtHL:
    lb bc, 5, 18
    
    push hl
    ld a, $0C
    ld [hli], a
    inc a ; ─
    call NPlaceChar
    inc a ; ┐
    ld [hl], a
    pop hl

    ld de, SCREEN_WIDTH
    add hl, de

.next
    push hl
    ld a, $0F
    ld [hli], a
    ld a, $1F
    call NPlaceChar
    ld [hl], $10
    pop hl

    ld de, SCREEN_WIDTH
    add hl, de
    dec b
    jr nz, .next
    
    ld a, $11
    ld [hli], a
    ld a, $0D
    call NPlaceChar
    ld [hl], $12
    ret

YesNo:
    call DrawTextBox
    call DrawYesNo
        ;ld hl, wOAMBuffer + $B8
    xor a
    ld [wCurrentMenuItem],a
    
.loop
    call M_HideSprites
    


    call JoypadLowSensitivity
    ld a, [$FFB5] ;hJoy5
    and %00110001
    and a ; was a key pressed?
    jr z, .loop
.keypressed
    	;ld b, a
    bit 0, a
    jr nz, .apressed
    bit 5, a
    jr z, .rightpressed
.leftpressed
    xor a
    ld [wCurrentMenuItem], a

    		;coord hl, 05, 03      ; $C3E1
    ld a, $15
    ld [$C3E1], a
    			;;;ld [hl], a

    			;coord hl, 08, 03
    ld a, $18
    ld [$C3E4], a
    			; ld [hl], a

    			;	coord hl, $0A, 03
    ld a, $1F
    ld [$C3E6], a
    ld [$C3E9], a
    				;ld [hl], a

    				;coord hl, $0D, 03
    			;		ld [hl], a
    
    jr .loop
.rightpressed
    ld a, 1
    ld [wCurrentMenuItem], a
    
    ld a, $1F
    ld [$C3E1], a
    ld [$C3E4], a

    ld a, $15
    ld [$C3E6], a

    ld a, $18
    ld [$C3E9], a


    jr .loop
.apressed
    call CloseTextBox
    ld a, [wCurrentMenuItem]
    sub 1	; set carry on yes
    ret

DrawYesNo:
    ld a, $5A
    ldh [$FFB0], a
    ld a, $9C
    ldh [$FFBD], a
    ldh [$FFBA], a
    coord hl, 1, 1 ; 13    
    ld bc, $0512
    call ClearScreenArea
    coord hl, 05, 03
    ld a, $15
    ld [hli], a		; dmskfsnjdkflsdna clad jndsacnadjsk
    inc a
    ld [hli], a
    inc a
    ld [hli], a
    inc a
    ld [hli], a
    inc a
    inc hl
    inc hl
    ld [hli], a
    inc a
    ld [hl], a
    ret

M_HideSprites:
    ldh a, [$FF44]	; LY
    cp $5A
    
    ldh a, [$FF40]
    jr c, .enable
    res 1, a	;and a, %11111101	;
    jr .set
.enable
    set 1, a
.set
    ldh [$FF40], a
    ret

CloseTextBox:
    ld a, $90
    ldh [$FFB0], a
    xor a
    ldh [$FFBA], a
    ld a, [$FF40]
    set 1, a
    ld [$FF40], a
    ret

DelayFrame_HideSprites:
    ld a, 1
    ld [$FFD6], a  ;H_VBLANKOCCURRED
.halt
    		;halt
    call M_HideSprites
    ld a, [$FFD6]
    and a
    jr nz, .halt
    ret
