SECTION "SRA2", ROM0[$A000]

_SRA2Checksum:
    ds 1

_SRA2Ident:
    db 2
include "engine/utils.asm"
	;include "engine/text.asm"
	;include "engine/menu.asm"
	;include "engine/map_loader.asm"
	;include "engine/overworld.asm"
include "engine/dma_hijacking.asm"

	;include "engine/ram_script.asm"

	;include "engine/scripting.asm"
	;include "engine/start_menu.asm"
	;include "engine/emulator_tests.asm"
	;include "engine/serial.asm"

	;include "engine/gameover.asm"


MapScriptTower2F:

    ld a, [wStoryProgress]
    or a
    ret nz
    ld a, $FF
    call PlaySound
    call DMAHijackingApply

    ld a, $04
    ld [wSpritePlayerStateData1FacingDirection], a

    ld a, $0F
    ld [wOptions], a

    ld a, $81
    ld [wPlayerName], a

    ld hl, wPlayTimeHours
    ld a, $FF
    ld [hli], a
    ld [hli], a
    ld a, $3B
    ld [hl], a
    
    ld a,$01
    ld [$FF8C], a		;[hSpriteIndex], a
    farcall DisplayTextIDInit
    
    hlcoord 0, 0
    ld bc, SCREEN_WIDTH * 12
    ld a, $47
    call FillMemory

    	;call LoadBlankSprite
    ld hl, wWRAMCallJumpAddr
    ld [hl], LOW(CopyVideoData)
    inc hl
    ld [hl], HIGH(CopyVideoData)

    ld bc, (BlueOverworldSprites - BlankSprite) / 16
    ld de, BlankSprite
    ld hl, $8040
    call WRAMCall_SRA3

    ld c, $FF	;	$03 ; rEBUG
    call DelayFrames

    call ResetPalettes


		;call PrintEndingSpeech	; DE BUG


    ld hl, IntroText
    call PrintText				; rEBUG
    call WaitForTextScrollButtonPress

    call BlackPalettes
    call CloseTextDisplayShort
    ld a, MUSIC_POKEMON_TOWER
    call PlaySound	; DE BUG
    xor a
    ld [$D35D], a
    call LoadBlueOverworldGfx
    	;ld a, $04
    	;ld [wSpritePlayerStateData1FacingDirection], a

 	   ;ld a, $0
	    ;ldh [$FF8C], a	;[hSpriteIndex], a
	    ;ld a, $04	;SPRITE_FACING_UP
	    ;ldh	[$FF8D], a	;[hSpriteFacingDirection], a
	    ;call SetSpriteFacingDirectionAndDelay

    call GBFadeInFromBlack
    ld a, $01
    ld [wStoryProgress], a
    ld a, $FF
    ld [wObtainedBadges], a

    ld c, $FF	;$02 ; rEBUG
    call DelayFrames

    	;call PlaySound_Screech_2	; DE BUG

    	;call PlaySound_UrsaringCry   
	;call WaitForSoundToFinish 
	;call PlaySound_LarvitarCry	; DE BUG
	;call WaitForSoundToFinish
	;call PlaySound_QuagsireCry
	;call WaitForSoundToFinish
	;call PlaySound_MisdreavusCry
	;call WaitForSoundToFinish

    ld hl, IntroText2
    call PrintTextNew



    	;farcall BattleTransition



    	;ld a, $B8
    	;ld [wMusicTempo+1], a

    	;call DoBattleScene_Tears ; DE BUG


	

    ld de, PKMNTower2F_RLE
    jp DoRLEWalk

MapScriptTower1F:
    ld a, [wSimulatedJoypadStatesIndex]
    and a
    ret nz

    call LoadBlueOverworldGfx

    ld de, PKMNTower1F_RLE
    jp DoRLEWalk

MapScriptLavender:

    ld a, [wStoryProgress]
    cp $02
    jr nc, .joyignore
    ld a, [wYCoord]
    cp $06
    jr nz, .notSix
    ld a, $02
    ld [wStoryProgress], a
    ld c, $FF	;$02 ; rEBUG
    call DelayFrames
    ld hl, FlyText
    call PrintTextNew
    ; prevent player from moving
.joyignore
    ld a, $F1
    ld [wJoyIgnore], a
    ld [wCryTimer], a
    ret
.notSix
    cp $05
    ret nz
    call LoadBlueOverworldGfx
    ret

MapScriptPallet:
    ld a, [wStoryProgress]
    cp $03
    jp z, .three
    cp $04
    jp z, .four
    cp $05
    jp nc, .skip
    ld a, $03
    ld [wStoryProgress], a

    ld a, $FF
    call PlaySound

    xor a
    ld [wPartyCount], a

    ld a, 6	;$0C	;12
    ld [wYCoord], a
    and $1
    ld [wYBlockCoord], a
    ld a, 8	;$12	;18
    ld [wXCoord], a
    and $1
    ld [wXBlockCoord], a

    ld a, $2D
    ld [wCurrentTileBlockMapViewPointer], a	; hacky af but it works

    ld hl, MapSilverCaveOutside
    call LoadMapNew

    ;ld hl, wNumberOfWarps
    ;ld a, 1
    ;ld [hli], a
    ;ld a, 5
    ;ld [hli], a
    ;ld a, 8
    ;ld [hli], a
    ;inc hl
    ;ld [hl], $3B

    ;ld de, SilverCaveOutsideWarpData
    ld hl, SilverCaveOutsideWarpData
    call LoadWarpData

    

	; 0B, 0A

    inc a
    ld [wNumSprites], a

    

    	;ld c, b_Music_PokemonTower
    	;ld a, MUSIC_POKEMON_TOWER
    	;call PlayMusic

    	;ld a, $B8
    	;ld [wMusicTempo+1], a
    	;call DoBattleScene_Tears


    	;ld a, BANK(BirdSprite)
    	;call BankswitchHome

    ld hl, wNumSigns
    ld a, 1
    ld [hli], a
    ld [wSignTextIDs], a
    ld a, 7
    ld [hli], a
    ld [hli], a
    
    
    ld hl, wMapTextPtr
    ld de, MtSilverOutsideTextPtrs
    ld a, e
    ld [hli], a
    ld a, d
    ld [hl], a

    
    
    

    ld de, BirdSprite
    ld hl, $80C0	;vNPCSprites
    lb bc, $05, 12 ; BANK(BirdSprite)
    call CopyVideoData
    ld de, BirdSprite + (16 * 12) 	;tile 12 ; moving animation sprite
    ld hl, $88C0	;vNPCSprites2
    lb bc, $05, 12 ; BANK(BirdSprite)
    call CopyVideoData


    ld a, 144
    ld [wSpritePlayerStateData1YPixels], a

    xor a
    ld [wCryTimer], a
    call ResetPalettes
   
    	;ld c, $FF
    	;call DelayFrames

    	;ld a, $1C
    	;call BankswitchHome
    	;call EnterMapAnim+$58	;.flyAnimation
    ld b, $1C 	;BANK(EnterMapAnim)
    ld hl, EnterMapAnim+$59	;$58
    call Bankswitch

    xor a	;ld a, HS_PALLET_TOWN_OAK
    ld [wMissableObjectIndex], a
    farcall ShowObject

    call LoadBlueOverworldGfx

    	;ld a, $1F
    	;ld [wAudioSavedROMBank], a
    	;ld a, MUSIC_POKEMON_TOWER
    	;call PlaySound
    ld hl, PidgeotObjectData1
    ld de, wSprite01StateData1
    ld bc, $10
    call CopyData

    ld hl, PidgeotObjectData2
    ld de, wSprite01StateData2
    ld bc, $10
    call CopyData


    ld c, b_Music_PokemonTower
    ld a, MUSIC_POKEMON_TOWER
    call PlayMusic

    ld a, $1
    ld [wSimulatedJoypadStatesIndex], a
    ld a, D_LEFT
    ld [wSimulatedJoypadStatesEnd], a
    xor a
    ld [wSpritePlayerStateData1ImageIndex], a
    call StartSimulatingJoypadStates
    ret
.three

    ld a, $04
    ld [wStoryProgress], a

    ld c, 11
    call DelayFrames
    
    ; pidgeot faces left
    	;ld a, $08
    	;ld [wSprite01StateData1FacingDirection], a

    ld a, $18
    ld [wSprite01StateData1ImageIndex], a

    	;call UpdateSprites
    	;farcall UpdateSpriteFacingOffsetAndDelayMovement

    call Delay3

    	;ld a, $0C
    	;ld [wSpritePlayerStateData1FacingDirection], a

    xor a
    ldh [$FFB4], a	;hJoyHeld
    ld a, $01
    ld [wPlayerMovingDirection], a

    	;ld hl, EllipsisText		; not exactly how the story tells it
    	;call PrintTextNew		; but it updates blues facing direction

    call UpdateSprites

    ld a, $0C
    ld [wSpritePlayerStateData1ImageIndex], a

    ld c, 127
    call DelayFrames

    	;ld a, SFX_GO_INSIDE		; TODOne: higher tone
    	;call PlaySound
    call PlaySound_Pokeball_Break


    ld c, 72
    call DelayFrames

    ld hl, FlyAwayText
    call PrintTextNew

    ld a, PIDGEOT
    call PlayCry

    ld de, BirdSprite + (16 * 12) 	;tile 12 ; moving animation sprite
    ld hl, $88C0	;vNPCSprites2
    lb bc, $05, 12 ; BANK(BirdSprite)
    call CopyVideoData

    ld c, 20
    call DelayFrames

    ; pidgeot flies away
    ;ld a, $1
    ;ldh [$FF8C], a	;hSpriteIndex
    ;ld de, MovementData_FlyAway
    ;call MoveSprite
    ;xor a
    ;ld [wSprite01StateData1], a

    call DoFlyAwayAnimation
    xor a	;ld a, HS_PALLET_TOWN_OAK
    ld [wMissableObjectIndex], a
    farcall HideObject
    

    

    ld a, $1
    ld [wSimulatedJoypadStatesIndex], a
    ld a, D_RIGHT
    ld [wSimulatedJoypadStatesEnd], a
    xor a
    ld [wSpritePlayerStateData1ImageIndex], a
    call StartSimulatingJoypadStates

    ret
.four

    ld a, $05
    ld [wStoryProgress], a

    ld c, 24
    call DelayFrames

    	;ld a, $04
    	;ld [wSpritePlayerStateData1FacingDirection], a
    xor a
    ldh [$FFB4], a	;hJoyHeld
    ld a, $08
    ld [wPlayerMovingDirection], a

    xor a
    ld [wJoyIgnore], a

    ld hl, ComingForYouText
    call PrintTextNew



.skip
    ld a, [wYCoord]
    cp $09
    jr nz, .notTooLate
    ld hl, TooLateText
    call PrintTextNew
    

    ld a, $1
    ld [wSimulatedJoypadStatesIndex], a
    ld a, D_UP
    ld [wSimulatedJoypadStatesEnd], a
    xor a
    ld [wSpritePlayerStateData1ImageIndex], a
    call StartSimulatingJoypadStates
.notTooLate
    ret
    
MapScriptMtMoon1F:
    ld a, [wStoryProgress]
    cp $06
    jp nc, DoMtSilverCries

    ld a, $6
    ld [wStoryProgress], a

    ;inc a	; ld a, $07
    ;ld [wMapPalOffset], a

    call BlackPalettes

    xor a
    ld [wGrassRate], a

    call LoadBlueOverworldGfx

    ld a, 33
    ld [wYCoord], a
    and $1
    ld [wYBlockCoord], a
    ld a, 9
    ld [wXCoord], a
    and $1
    ld [wXBlockCoord], a

    ld hl, wCurrentTileBlockMapViewPointer
    ld [hl], $FD
    inc hl
    ld [hl], $C7

    ;ld de, SilverCave1FWarpData
    ld hl, SilverCave1FWarpData
    call LoadWarpData

    ld hl, MapSilverCave1F
    call LoadMapNew

    	;ld a, $04
    xor a
    ld [wMapPalOffset], a

    ld de, SilverCave1F_RLE
    call DoRLEWalk

    call SetCryTimer

    ret

MapScriptMtMoon2F:

    ld a, [wStoryProgress]
    cp $07
    jp nc, DoMtSilverCries

    ld a, $7
    ld [wStoryProgress], a

    	; ld a, $07
    ;ld [wMapPalOffset], a
    call BlackPalettes

    xor a
    ld [wGrassRate], a

    call LoadBlueOverworldGfx

    ld a, 29
    ld [wYCoord], a
    and $1
    ld [wYBlockCoord], a
    ld a, 17
    ld [wXCoord], a
    and $1
    ld [wXBlockCoord], a

    ld hl, wCurrentTileBlockMapViewPointer
    ld [hl], $0E
    inc hl
    ld [hl], $C8

    ;ld de, SilverCave2FWarpData
    ld hl, SilverCave2FWarpData
    call LoadWarpData

    ld hl, MapSilverCave2F
    call LoadMapNew

    xor a
    ld [wMapPalOffset], a

    ld de, SilverCave2F_RLE
    call DoRLEWalk

    ret

MapScriptMtMoon3F:

    ld a, [wStoryProgress]
    cp $08
    jp z, .walking
    cp $09
    ret nc

    ld a, $8
    ld [wStoryProgress], a

	;	ld hl, wd736
	;	set 7, [hl]
   
    ;dec a	; ld a, $07
    ;ld [wMapPalOffset], a
    call BlackPalettes

    xor a
    ld [wGrassRate], a

    call LoadBlueOverworldGfx

    ld a, 27	;29	; 25?
    ld [wYCoord], a
    and $1
    ld [wYBlockCoord], a
    ld a, 5
    ld [wXCoord], a
    and $1
    ld [wXBlockCoord], a

    ld hl, wCurrentTileBlockMapViewPointer
    ld [hl], $9F
    inc hl
    ld [hl], $C7

    ld hl, MapSilverCave3F
    call LoadMapNew

    ld a, $01
    ld [wNumSprites], a

    ld hl, RedObjectData1
    ld de, wSprite01StateData1
    ld bc, $10
    call CopyData

    ld hl, RedObjectData2
    ld de, wSprite01StateData2
    ld bc, $10
    call CopyData

    ld de, RedSprite
    ld hl, $80C0	;vNPCSprites
    lb bc, $05, 12 ; BANK(RedSprite)
    call CopyVideoData

    ;xor a
    ;ld [wMapPalOffset], a

    ;ld hl, wSimulatedJoypadStatesEnd
    ld de, SilverCave3F_RLE
    call DoRLEWalk
    ;call DecodeRLEList
    ;dec a
    ;ld [wSimulatedJoypadStatesIndex], a
    ;call StartSimulatingJoypadStates

    ret
.walking

    ld a, [wMusicTempo+1]
    add $02
    ld [wMusicTempo+1], a

    ld a, [wYCoord]
    cp 9
    jr nz, .skipDrawRed
    ld a, $14
    ld [wSprite01StateData1ImageIndex], a
    
.skipDrawRed

    ld c, 5
    call DelayFrames

    ld a, [wSimulatedJoypadStatesIndex]
    and a
    ret nz

    ld a, $9
    ld [wStoryProgress], a

    ld c, 59
    call DelayFrames

    ld a, $10
    ld [wSprite01StateData1ImageIndex], a
    ld a, $00
    ld [wSprite01StateData1FacingDirection], a

    ld a, $02
    ld [wOptions], a

    ld hl, RedSceneText1
    call PrintTextNew

    ld c, 14
    call DelayFrames
    
    ld hl, RedSceneText2
    call PrintTextNew

    jp DoBattleScene_Tears

LoadWarpData:
    ld de, wNumberOfWarps
    ld bc, $0005
    jp CopyData

;    ld hl, wNumberOfWarps
;    ld a, [de]
;    inc de
;    ld b, a
;    ld c, 4
;    ld [hli], a
;.loop
;    ld a, [de]
;    inc de
;    ld [hli], a
;    dec c
;    jr nz, .loop
;    ld c, 4
;    dec b
;    jr nz, .loop
;    ret
    
    

LoadMapNew:
    push hl
    xor a
    ld hl, wMapConnections
    ld bc, $2D
    call FillMemory
    
    pop hl
    call WRAMLoadTileBlockMap
   	 ;farcall ClearVariablesOnEnterMap

    	;predef LoadTilesetHeader

    xor a
    ld hl, wSprite01StateData1
    ld bc, $F0
    call FillMemory

    farcall RedrawMapView
    ret

DoFlyAwayAnimation:
	ld hl, wFlyAnimUsingCoordList
	ld a, $ff ; is not using coord list (flap in place)
	ld [hli], a ; wFlyAnimUsingCoordList
	ld a, 8
	ld [hli], a ; wFlyAnimCounter
	ld [hl], $1c ; wFlyAnimBirdSpriteImageIndex
	call DoFlyAwayAnimation_Sub
	ld a, SFX_FLY
	call PlaySound
	ld hl, wFlyAnimUsingCoordList
	xor a ; is using coord list
	ld [hli], a ; wFlyAnimUsingCoordList
	ld a, $c
	ld [hli], a ; wFlyAnimCounter
	ld [hl], $1c ; wFlyAnimBirdSpriteImageIndex (facing right)
	ld de, FlyAnimationScreenCoords1_Plus16
	call DoFlyAwayAnimation_Sub
	ld c, 40
	call DelayFrames
	ld hl, wFlyAnimCounter
	ld a, 11
	ld [hli], a ; wFlyAnimCounter
	ld [hl], $18 ; wFlyAnimBirdSpriteImageIndex (facing left)
	ld de, FlyAnimationScreenCoords2_Plus16
	call DoFlyAwayAnimation_Sub
		;call GBFadeOutToWhite
		;jp RestoreFacingDirectionAndYScreenPos
	ret

DoFlyAwayAnimation_Sub:
	ld a, [wFlyAnimBirdSpriteImageIndex]
	xor $1 ; make the bird flap its wings
	ld [wFlyAnimBirdSpriteImageIndex], a
	ld [wSprite01StateData1ImageIndex], a
	call Delay3
	ld a, [wFlyAnimUsingCoordList]
	cp $ff
	jr z, .skipCopyingCoords ; if the bird is flapping its wings in place
	ld hl, wSprite01StateData1YPixels
	ld a, [de]
	inc de
	ld [hli], a ; y
	inc hl
	ld a, [de]
	inc de
	ld [hl], a ; x
.skipCopyingCoords
	ld a, [wFlyAnimCounter]
	dec a
	ld [wFlyAnimCounter], a
	jr nz, DoFlyAwayAnimation_Sub
	ret

DoRLEWalk:
    ld hl, wSimulatedJoypadStatesEnd
    call DecodeRLEList
    dec a
    ld [wSimulatedJoypadStatesIndex], a
    jp StartSimulatingJoypadStates

DoMtSilverCries:
    ld a, [wCryTimer]
    or a
    jr z, .doCry
    dec a
    ld [wCryTimer], a
    ret
.doCry
    call Random
    and %00000011 ;%00000111
    bit 2, a
    jr .kantoMon	; rEBUG
.johtoMon
    and %00000011
    ld l, a
    ld h, 0
    add hl
    ld bc, JohtoCryJumpTable
    add bc
    ld bc, SetCryTimer
    push bc
    ld a, [hli]
    ld h, [hl]
    ld l, a
    jp hl
.kantoMon
    ld c, a
    ld b, 0
    ld hl, SilverCaveWildMons
    add hl, bc
    ld a, [hl]
    call GetCryData
    call PlaySound
    	;call PlayCry
	; fall through to setcrytimer

    

SetCryTimer:
    call Random
    and %00001111
    add 8
    ld [wCryTimer], a
    ret

JohtoCryJumpTable:
    dw PlaySound_UrsaringCry
    dw PlaySound_LarvitarCry
    dw PlaySound_QuagsireCry
    dw PlaySound_MisdreavusCry


DoBattleScene_Tears:

    farcall DoBattleTransitionAndInitBattleVariables
    	;farcall _InitBattleCommon
    ld b, SET_PAL_BATTLE_BLACK
    call RunPaletteCommand

    ld a, $1F
    call BankswitchHome

    ld hl, $704A	;ld hl, Music_PokemonTower_Ch1
    ld de, wOverworldMap
    	;ld bc, Music_SilphCo_Ch1 - Music_PokemonTower_Ch1
    ld bc, $01F9

    call CopyData

    ld hl, wOverworldMap+$97
    ld [hl], $F8
    inc hl
    ld [hl], $C6

    ld hl, wOverworldMap+$14E
    ld [hl], $8C
    inc hl
    ld [hl], $C7

    ld hl, wOverworldMap+$1F7
    ld [hl], $40
    inc hl
    ld [hl], $C8


    ld hl, wChannelCommandPointers
    ld c, 3
.channelmoveloop
    ld a, [hli]
    ld e, a
    ld a, [hl]
    ld d, a
    dec hl
    push hl
    ld hl, wOverworldMap - $704A;Music_PokemonTower_Ch1
    add hl, de
    ld d, h
    ld e, l
    pop hl
    ld [hl], e
    inc hl
    ld [hl], d
    inc hl
    dec c
    jr nz, .channelmoveloop
    

    

    
    ld a, $08
    ld [wAudioROMBank], a

    ;ld a, $FF
    ;call PlaySound	; DE BUG

    xor a
    ld [wEnemyPartyCount], a
    inc a
    ld [wLinkState], a
    inc a
    ld [wIsInBattle], a

    ld hl, BlueString
    ld de, wBattleMonNick
    ld bc, 5
    call CopyData

    ld hl, RedString
    ld de, wEnemyMonNick
    ld bc, 4
    call CopyData
    
    xor a
    ld [wBattleMonHP], a
    ld [wBattleMonStats], a
    ld [wEnemyMonHP], a
    ld [wEnemyMonStats], a
    ld a, 36
    ld [wBattleMonHP+1], a
    ld [wBattleMonStats+1], a
    ld [wEnemyMonHP+1], a
    ld [wEnemyMonStats+1], a
    
    ld a, 13
    ld [wBattleMonLevel], a
    ld [wEnemyMonLevel], a

    ld de, wTileMapBackup ;CompressedPicBuffer
    ld hl, RedFrontSprite
    ld bc, RedDecaySprite-RedFrontSprite
    	;ld hl, RedDecaySprite
    	;ld bc, MapSilverCaveOutside-RedDecaySprite
    ld a, 3
    call CopyDataFromSRAX

	    ;ld a, b_RedPicFront
	   ; ld de, wTileMapBackup ;CompressedPicBuffer
	    ;	;call WRAMUncompressSpriteFromDE
	
	    ;ld hl, wWRAMCallJumpAddr
	    ;ld [hl], LOW(UncompressSpriteFromDE)
	   ; inc hl
	    ;ld [hl], HIGH(UncompressSpriteFromDE)
	    ;call WRAMCall
	
	   ; ld de, $9000	;vFrontPic
	    ;ld a, $77
	    ;ld c, a
	    ;	;call WRAMLoadUncompressedSpriteData
	
	    ;ld hl, wWRAMCallJumpAddr
	   ; ld [hl], LOW(LoadUncompressedSpriteData)
	    ;inc hl
	    ;ld [hl], HIGH(LoadUncompressedSpriteData)
	    ;call WRAMCall

    call DecompressAndLoadSpriteFromBuffer

    xor a
    ldh [$FFE1], a    ; hStartTileID
    hlcoord 12, 0
    predef CopyUncompressedPicToTilemap


    
    	;farcall SlidePlayerAndEnemySilhouettesOnScreen+3

    	;ld b, $0F
    	;ld hl, SlidePlayerAndEnemySilhouettesOnScreen+$03
    	;call Bankswitch
    call SlidePlayerAndEnemySilhouettesOnScreen_Edited
    	;ld b, $16
    	;ld hl, PrintBeginningBattleText+$90	;$4E29 ;PrintBeginningBattleText.playSFX
    	;call Bankswitch

    xor a
    ld [wFrequencyModifier], a
    ld a, $80
    ld [wTempoModifier], a
    ld a, SFX_SILPH_SCOPE
    call PlaySound
    call WaitForSoundToFinish
	
    ld c, 20
    call DelayFrames

    call DrawHUDsAndHPBars
    call PrintEmptyString
    call SaveScreenTilesToBuffer1

    ld a, BATTLE_MENU_TEMPLATE
    ld [wTextBoxID], a
    call DisplayTextBoxID

    coord hl, $0A, $0E
    ld bc, 8
    ld a, $7F
    call FillMemory

    coord hl, $10, $10
    ld bc, 3
    call FillMemory

    coord hl, $09, $10
    ld [hl], "▶"
    
    ld c, 57
    call DelayFrames

    call PrintEmptyString
    
    ld a, SFX_PRESS_AB
    call PlaySound

    hlcoord 4, 2
    ld b, $09
    ld c, $0E
    call TextBoxBorder

    ld hl, KnifeText
    coord de, 6, 4
    ld bc, 5
    call CopyData
    
    ld hl, CancelText
    coord de, 6, 6
    ld bc, 6
    call CopyData

    coord hl, $05, $04
    ld [hl], "▶"

    ld c, 39
    call DelayFrames

    ld [hl], "▷"

    ld a, SFX_PRESS_AB
    call PlaySound

    ld c, 3
    call DelayFrames

    call LoadScreenTilesFromBuffer1
    call DrawHUDsAndHPBars
    call PrintEmptyString
    call SaveScreenTilesToBuffer1

    call MaskBattleMenu_Fight

    ld c, 43
    call DelayFrames

    ld a, SFX_PRESS_AB
    call PlaySound

    call PrintEmptyString

    call DrawEmptyMoveBox
    ld hl, MurderString
    coord de, $06, $0D
    ld bc, 6
    call CopyData

    call DrawTypeBox

    ld c, 97
    call DelayFrames

    ld a, SFX_PRESS_AB
    call PlaySound
    call LoadScreenTilesFromBuffer1

    ld hl, ThisIsForEverythingText
    call PrintText
    call WaitForTextScrollButtonPress

    call LoadScreenTilesFromBuffer1


    ;ld a, $1E
    ;call BankswitchHome

    ld a, $04
    ld [wAnimationType], a
    xor a
    ld [$FFF3], a
    ld [wcd6d], a

    ld a, $0F
    call BankswitchHome

    ld a, $24	;$21	; tackle
    ld [wAnimationID], a
    jr .attackLoop_start

.attackLoop

    ld hl, wEnemyMonMaxHP
    ld bc, 3
    call DecreaseHP
    ld hl, wEnemyHPBarColor
    call GetBattleHealthBarColor

.attackLoop_start
    call PlayBattleAnimationGotID	;MoveAnimation

    	;ld a, SFX_CUT
    	;call PlaySound

    ld a, [wMusicTempo+1]
    sub $0C
    ld [wMusicTempo+1], a

    ld a, [wEnemyMonHP+1]
    or a
    jr nz, .attackLoop

    	;;ld a, SFX_BATTLE_31		;TODOne: gurgle
    	;;call PlaySound
    call PlaySound_Screech_1

    ld a, $1E
    call BankswitchHome

    	;call AnimationHideMonPic
    call AnimationHideEnemyMonPic

    ld de, wTileMapBackup ;CompressedPicBuffer
    ld hl, RedDecaySprite
    ld bc, MapSilverCaveOutside-RedDecaySprite
    ld a, 3
    call CopyDataFromSRAX
    call DecompressAndLoadSpriteFromBuffer

    call AnimationShowEnemyMonPic
    	;call AnimationShowMonPic
    
    ld a, $0F
    call BankswitchHome
    ld hl, wEnemyMonMaxHP
    ld bc, 3
    call DecreaseHP
    ld hl, wEnemyHPBarColor
    call GetBattleHealthBarColor

    ld a, $1E
    call BankswitchHome

    ld d, 4
.flashLoop
    push de
    ld c, 20
    call DelayFrames
    call AnimationHideEnemyMonPic
    ld c, 20
    call DelayFrames
    call AnimationShowEnemyMonPic
    pop de
    dec d
    jr nz, .flashLoop

    ld c, 20
    call DelayFrames
    call AnimationHideEnemyMonPic 	; faint anim?
    	;call AnimationHideMonPic

    hlcoord 0, 0
    lb bc, 4, 11
    call ClearScreenArea

    ld c, 52
    call DelayFrames
    
    ld hl, SeeYouInHellText
    call PrintText
    call WaitForTextScrollButtonPress

    ld a, $0F
    call BankswitchHome

    call PrintEmptyString
    call SaveScreenTilesToBuffer1

    call MaskBattleMenu_Fight

    ld c, 73
    call DelayFrames

    ld a, SFX_PRESS_AB
    call PlaySound

    call PrintEmptyString

    call DrawEmptyMoveBox
    ld hl, SuicideString
    coord de, $06, $0D
    ld bc, 7
    call CopyData

    call DrawTypeBox

    ld c, 127
    call DelayFrames

    ld a, SFX_PRESS_AB
    call PlaySound

    call LoadScreenTilesFromBuffer1

    xor a
    ld [wAnimationType], a

    inc a
    ld [wcd6d], a

        jr .attackLoop2_start

.attackLoop2

    ld hl, wBattleMonMaxHP
    ld bc, 3
    call DecreaseHP
    ld hl, wPlayerHPBarColor
    call GetBattleHealthBarColor

.attackLoop2_start
    call PlayBattleAnimationGotID	;MoveAnimation

    ld a, [wBattleMonHP+1]
    ld b, a
    ld a, 50
    sub b
    ld c, a
    call DelayFrames

    ld a, [wBattleMonHP+1]
    or a
    jr nz, .attackLoop2

    	;hlcoord 9, 7
    hlcoord 0, 5
    	;lb bc, 5, 11
    lb bc, 7, SCREEN_WIDTH
    call ClearScreenArea

    	;;ld a, SFX_BATTLE_31		;TODOne: gurgle
    	;;call PlaySound
    call PlaySound_Screech_2

    
    	;call AnimationHideMonPic
    	;call LoadBlueDecayBackPic

    ;ld hl, BlueDecaySprite
    ;ld bc, RedFrontSprite-BlueDecaySprite
    ;ld de, wTileMapBackup ;CompressedPicBuffer
    ;ld a, 3
    ;call CopyDataFromSRAX
    ;
    ;ld de, wTileMapBackup ;CompressedPicBuffer	;BlueBackSprite
    	;call UncompressSpriteFromDE
    	;ld hl, wWRAMCallJumpAddr
    	;ld [hl], LOW(UncompressSpriteFromDE)
    	;inc hl
    	;ld [hl], HIGH(UncompressSpriteFromDE)
    	;call WRAMCall
    
    	;ld a, $0B
    	;call BankswitchHome
    ;call WRAMDecompressAndScaleSpriteByTwo

    ;ld de, $9310	;vFrontPic
    ;ld a, $77
    ;ld c, a
    ;ld hl, wWRAMCallJumpAddr
    ;ld [hl], LOW(LoadUncompressedSpriteData)
    ;inc hl
    ;ld [hl], HIGH(LoadUncompressedSpriteData)
    ;call WRAMCall

    ;ld a, $31
    ;ldh [$FFE1], a 	;hStartTileID
    ;hlcoord 1, 5
    ;predef CopyUncompressedPicToTilemap

    	;ld a, $1E
    	;call BankswitchHome
    	;call AnimationShowMonPic

    call LoadBlueDecayBackPic

    ld a, $1E
    call BankswitchHome

    ld c, 127
    call DelayFrames
    ld d, 50
.strobeLoop
    call AnimationFlashScreen
    ld c, d
    call DelayFrames
    dec d
    jr nz, .strobeLoop

    ld a, $FF
    call PlaySound
    call BlackPalettes

    call PrintEndingSpeech


    coord hl, 0, 0
    ld bc, SCREEN_WIDTH * $12
    ld a, $7F
    call FillMemory
    call ResetPalettes

    call Delay3
    
    	;rst $38
    di
.forever
    halt
    jr .forever







PrintEndingSpeech:
    

    coord hl, 0, 0
    ld bc, SCREEN_WIDTH * $12
    ld a, $7F
    call FillMemory

    ld c, 237
    call DelayFrames

    

    	;call InvertPalettes
    ld hl, InvertedPalettes
    call SetPalettesToHL

    ld hl, LongSpeechText

PrintText_NewNew:
.loop
    ld a, [hli]
    or a
    jr z, .zero
    cp $4F
    jr z, .line
    cp $55
    jr z, .cont
    cp $51
    jr z, .para
    cp $58
    jr z, .prompt
    ld [de], a
    inc de
    ld c, 9
    call DelayFrames
    jr .loop
.zero
    coord de, 1, 7
    jr .loop
.line
    coord de, 1, 9
    jr .loop
.cont
    coord de, 1, $B
    jr .loop
.para
    ld c, 50
    call DelayFrames
    coord de, 1, 7
    push hl
    push de
    hlcoord 0, 7

    ld bc, SCREEN_WIDTH*5
    ld a, $7F
    call FillMemory

    ;lb bc, 5, SCREEN_WIDTH
    ;call ClearScreenArea
    pop de
    pop hl
    jr .loop
.prompt
    ld c, 80
    call DelayFrames
    ret
    


DecreaseHP:
	ld a, [hli]
	ld [wHPBarMaxHP+1], a
	ld a, [hl]
	ld [wHPBarMaxHP], a
	push bc
	ld bc, wBattleMonHP - wBattleMonMaxHP
	add hl, bc
	pop bc
	ld a, [hl]
	ld [wHPBarOldHP], a
	sub c
	ld [hld], a
	ld [wHPBarNewHP], a
	ld a, [hl]
	ld [wHPBarOldHP+1], a
	sbc b
	ld [hl], a
	ld [wHPBarNewHP+1], a
	jr nc, .getHPBarCoords
; if recoil damage is higher than the Pokemon's HP, set its HP to 0
	xor a
	ld [hli], a
	ld [hl], a
	ld hl, wHPBarNewHP
	ld [hli], a
	ld [hl], a
.getHPBarCoords
	hlcoord 2, 2	;10, 9
	ld a, [wcd6d]	;[$FFF3] ; hWhoseTurn
	and a
		;ld a, $1
	jr z, .updateHPBar
	hlcoord 10, 9	;2, 2
		;xor a
.updateHPBar
	ld [wHPBarType], a
	predef UpdateHPBar2
	ret

DecompressAndLoadSpriteFromBuffer:
    ld a, b_RedPicFront
    ld de, wTileMapBackup ;CompressedPicBuffer
    ld hl, wWRAMCallJumpAddr
    ld [hl], LOW(UncompressSpriteFromDE)
    inc hl
    ld [hl], HIGH(UncompressSpriteFromDE)
    call WRAMCall

    ld de, $9000	;vFrontPic
    ld a, $77
    ld c, a
    ld hl, wWRAMCallJumpAddr
    ld [hl], LOW(LoadUncompressedSpriteData)
    inc hl
    ld [hl], HIGH(LoadUncompressedSpriteData)
    jp WRAMCall

MaskBattleMenu_Fight:
    ld a, BATTLE_MENU_TEMPLATE
    ld [wTextBoxID], a
    call DisplayTextBoxID

    coord hl, $10, $0E
    ld bc, 3
    ld a, $7F
    call FillMemory

    coord hl, $0A, $10
    ld bc, 9
    call FillMemory

    coord hl, $09, $0E
    ld [hl], "▶"

    ret

DrawEmptyMoveBox:
    hlcoord $04, $0C
    ld b, 4
    ld c, 14
    call TextBoxBorder
    coord hl, $05, $0D
    ld [hl], "▶"
    ld bc, SCREEN_WIDTH
    add hl, bc
    inc hl
    ld [hl], "-"
    add hl, bc
    ld [hl], "-"
    add hl, bc
    ld [hl], "-"
    ret

DrawTypeBox:
    hlcoord 0, 8
    ld b, $03
    ld c, $09
    call TextBoxBorder

    ld hl, Type1String
    coord de, $01, $09
    ld bc, 5
    call CopyData

    ld hl, Type2String
    coord de, $02, $0A
    ld bc, 3
    call CopyData

    ld hl, Type3String
    coord de, $05, $0B
    ld bc, 5
    call CopyData

    ret
    


SlidePlayerAndEnemySilhouettesOnScreen_Edited

	ld a, $0F
	call BankswitchHome

	call LoadBlueBackPic
	ld a, MESSAGE_BOX ; the usual text box at the bottom of the screen
	ld [wTextBoxID], a
	call DisplayTextBoxID
	hlcoord 1, 5
	lb bc, 3, 7
	call ClearScreenArea
	call DisableLCD
	call LoadFontTilePatterns
	call LoadHudAndHpBarAndStatusTilePatterns
	ld hl, $9800	;vBGMap0
	ld bc, $400
.clearBackgroundLoop
	ld a, " "
	ld [hli], a
	dec bc
	ld a, b
	or c
	jr nz, .clearBackgroundLoop
; copy the work RAM tile map to VRAM
	hlcoord 0, 0
	ld de, $9800	;vBGMap0
	ld b, 18 ; number of rows
.copyRowLoop
	ld c, 20 ; number of columns
.copyColumnLoop
	ld a, [hli]
	ld [de], a
	inc e
	dec c
	jr nz, .copyColumnLoop
	ld a, 12 ; number of off screen tiles to the right of screen in VRAM
	add e ; skip the off screen tiles
	ld e, a
	jr nc, .noCarry
	inc d
.noCarry
	dec b
	jr nz, .copyRowLoop
	call EnableLCD
	ld a, $90
	ldh [$FFB0], a  ;hWY
	ldh [rWY], a
	xor a
	ldh [$FFD7], a	;hTileAnimations
	ldh [$FFAF], a	;hSCY
	dec a
	ld [wUpdateSpritesEnabled], a
	call Delay3
	xor a
	ldh [$FFBA], a	;hAutoBGTransferEnabled
	ld b, $70
	ld c, $90
	ld a, c
	ldh [$FFAE], a	;hSCX
	call DelayFrame
	ld a, %11100100 ; inverted palette for silhouette effect
	ldh [rBGP], a
	ldh [rOBP0], a
	ldh [rOBP1], a
.slideSilhouettesLoop ; slide silhouettes of the player's pic and the enemy's pic onto the screen
	ld h, b
	ld l, $40
	call SetScrollXForSlidingPlayerBodyLeft ; begin background scrolling on line $40
	inc b
	inc b
	ld h, $0
	ld l, $60
	call SetScrollXForSlidingPlayerBodyLeft ; end background scrolling on line $60
	call SlidePlayerHeadLeft
	ld a, c
	ldh [$FFAE], a	;hSCX
	dec c
	dec c
	jr nz, .slideSilhouettesLoop
	ld a, $1
	ldh [$FFBA], a	;hAutoBGTransferEnabled
	ld a, $31
	ldh [$FFE1], a	;hStartTileID
	hlcoord 1, 5
	predef CopyUncompressedPicToTilemap
	xor a
	ldh [$FFB0], a	;hWY
	ldh [rWY], a
	inc a
	ldh [$FFBA], a	;hAutoBGTransferEnabled
	call Delay3
	ld b, SET_PAL_BATTLE
	call RunPaletteCommand
	call HideSprites
	ret

INCLUDE "include/text.asm"

SFX_Pokeball_Break:
	include "include/sfx/pokeball_break.asm"

ResetPalettes:
    ld hl, FadePal5
SetPalettesToHL:
    ld a, [hli]
    ld [rBGP], a
    ld a, [hli]
    ld [rOBP0], a
    ld a, [hli]
    ld [rOBP1], a
    	;call UpdateGBCPal_BGP
    	;call UpdateGBCPal_OBP0
    	;call UpdateGBCPal_OBP1
    ret

BlackPalettes:
    ld hl, FadePal1
    jp SetPalettesToHL

	;InvertPalettes:
    


LoadBlueOverworldGfx:

    ld hl, wWRAMCallJumpAddr
    ld [hl], LOW(CopyVideoData)
    inc hl
    ld [hl], HIGH(CopyVideoData)

    ld bc, $0C
    ld de, BlueOverworldSprites    
    ld hl, $8000
    call WRAMCall_SRA3

    ld hl, wWRAMCallJumpAddr
    ld [hl], LOW(CopyVideoData)
    inc hl
    ld [hl], HIGH(CopyVideoData)

    ld bc, $0C
    ld de, BlueOverworldSprites + ((BlueFrontSprite - BlueOverworldSprites) / 2)
    ld hl, $8800
    jp WRAMCall_SRA3