SECTION "WRAM", ROM0[$DA80]

_EntryPoint:
    call SwitchToSRA2
    ld a, [wOnSGB]
    ld [wOrigOnSGB], a

    ld a, [wCurMap]
    cp $8F
    jp z, MapScriptTower2F
    cp $8E
    jp z, MapScriptTower1F
    cp $04
    jp z, MapScriptLavender
    or a	;cp $00
    jp z, MapScriptPallet
    cp $3B
    jp z, MapScriptMtMoon1F
    cp $3D
    jp z, MapScriptMtMoon2F
    cp $3C
    jp z, MapScriptMtMoon3F
    ret

wOrigOnSGB:
    ds 1
wDMAHijackingEnabled:
    ds 1
wRAMScriptFillByte:
    ds 1
wStoryProgress:
    ds 1
wCopiedVideoData:
    ds 1
wCryTimer
    ds 1

SwitchToSRA2:
    ld a, 2
SwitchToSRAX:
    ld [wCurrentSRAMBank], a
SwitchToSRAX_NoPreserve:
    ld [$4000], a
    ld a, $0a
    ld [$0000], a
    ret
SwitchToSRA3:
    ld a, 3
    jr SwitchToSRAX

wCurrentSRAMBank:
    ds 1

SafeCall:
    db $cd ; call
wSafeCallAddressLow:
    ds 1
wSafeCallAddressHigh:
    ds 1
RestoreAndReturn:
    ld a, [wCurrentSRAMBank]
    jr SwitchToSRAX
SafeCallHL:
    call .jp_hl
    jr RestoreAndReturn
.jp_hl
    jp hl

CopyDataFromSRAX:
    call SwitchToSRAX_NoPreserve
    call CopyData
    jr RestoreAndReturn

ReadFromSRA0:
    xor a
ReadFromSRAX:
    call SwitchToSRAX_NoPreserve
    ld a, [hl]
    push af
    call RestoreAndReturn
    pop af
    ret

;RecvExactWRAMDelegate:
;    xor a
;    call SwitchToSRAX_NoPreserve
;    ;ld a, [hl] ; stop on $ff in target buffer - protects against overflows
;    ;inc a
;    ;ret z
;.wait
;    ldh a, [$02]
;    bit 7, a
;    jr nz, .wait
;.received
;    ldh a, [$01]
;    xor e
;    ld [hli], a
;    ld a, 2
;    call SwitchToSRAX_NoPreserve
;    dec bc
;    ld a, c
;    or b
;    jp nz, RecvExact
;    ret

StandardTextboxDelegate:
    db 8 ; TX_ASM
    call SwitchToSRA2
    	;call RunNPCScript
    jp TextScriptEnd

DetermineCurrentSRABank:
    ld a, [_SRA2Ident]
    cp 2
    ret z
    cp 3
    ret z
    xor a
    ret

CommonMapScr:
    ret

DMAHijackingRoutine:
    add sp, 12
    pop de
    ld hl, wDMAHijackingReturnAddress
    ld [hl], e
    inc hl
    ld [hl], d
    ld hl, DMAHijackingReturn
    push hl
    add sp, -12
    
    ld a, $c3
    ld c, $46
    ret

DMAHijackingReturn:
    push af
    push bc
    push de
    push hl
    ld a, [wDMAHijackingEnabled]
    and a
    jr z, .disabled
    call DetermineCurrentSRABank
    push af
    ld a, 2
    call SwitchToSRAX_NoPreserve
    call DMAHijackingProc
    pop af
    call SwitchToSRAX_NoPreserve
.disabled
    pop hl
    pop de
    pop bc
    pop af
    db $c3 ; jp
wDMAHijackingReturnAddress:
    ds 2


LoadBlueDecayBackPic:
    call SwitchToSRA3
    
    ld hl, BlueDecaySprite
    ld bc, RedFrontSprite-BlueDecaySprite
    	;jp SwitchToSRA2
    ld de, wTileMapBackup ;CompressedPicBuffer
    
    call CopyData

    ld de, wTileMapBackup ;CompressedPicBuffer	;BlueBackSprite
    
    call UncompressSpriteFromDE
    predef ScaleSpriteByTwo
    ld de, $9310	;vBackPic
    call InterlaceMergeSpriteBuffers

    xor a
    call SwitchToSRAX
    ld hl, $8000	;vSprites
    ld de, sSpriteBuffer1
    ldh a, [$FFB8]	;[hLoadedROMBank]
    ld b, a
    ld c, 7 * 7
    call CopyVideoData

    hlcoord 1, 5
    predef CopyUncompressedPicToTilemap

    jp SwitchToSRA2
LoadBlueBackPic:
    call SwitchToSRA3
    
    ld hl, BlueBackSprite
    ld bc, BlueDecaySprite-BlueBackSprite
    
.enter
    ld de, wTileMapBackup ;CompressedPicBuffer
    
    call CopyData

    ld de, wTileMapBackup ;CompressedPicBuffer	;BlueBackSprite
    	;farcall LoadPlayerBackPic+$0C
    ld b, $0F
    ld hl, LoadPlayerBackPic+$0C
    call Bankswitch

    jp SwitchToSRA2

;LoadBlueOverworldGfx:
;    ld a, 3
;    call SwitchToSRAX_NoPreserve
;    
;    ld bc, $0C
;    ld de, BlueOverworldSprites
;    ld hl, $8000
;    call CopyVideoData
;    
;    ld bc, $0C
;    ld de, BlueOverworldSprites + ((BlueFrontSprite - BlueOverworldSprites) / 2)
;    ld hl, $8800
;    call CopyVideoData
;    jp RestoreAndReturn

;LoadBlankSprite:
;    ld a, 3
;    call SwitchToSRAX_NoPreserve
;    
;    ld c, (BlueOverworldSprites - BlankSprite) / 16
;    ld b, 0
;    ld de, BlankSprite
;    ld hl, $8040
;    call CopyVideoData
;    
;    jp RestoreAndReturn

PrintTextNew:
    push hl 
    ld a,$01
    ld [$FF8C], a		;[hSpriteIndex], a
    farcall DisplayTextIDInit
    pop hl
    call PrintText
    call WaitForTextScrollButtonPress
    	;jp CloseTextDisplayShort ; fall through

CloseTextDisplayShort:
    ld a, $90
    ldh [$FFB0], a	;[hWY], a
    call DelayFrame
    call LoadGBPal
    xor a
    ldh [$FFBA], a	;[hAutoBGTransferEnabled], a
    farcall InitMapSprites
    call LoadBlueOverworldGfx
    ld hl, wFontLoaded
    res 0, [hl]
    call LoadCurrentMapView
    ret

;CopyBlueFrontSprite:
;    call SwitchToSRA3
;    ld bc, $0020
;    ld de, BlueFrontSprite
;    ld hl, $9000
;    call CopyVideoData
;    jp SwitchToSRA2

;CopyBlackTile:
;    call SwitchToSRA3
;    ld bc, $0001
;    ld de, BlackTile
;    ld hl, $9660
;    call CopyVideoData
;    jp SwitchToSRA2

WRAMLoadTileBlockMap:
    call SwitchToSRA3
    ld a, [hli]
    ld [wCurMapTileset], a
    ld a, [hli]
    ld [wMapBackgroundTile], a
    ld a, [hli]
    ld [wCurMapWidth], a
    ld a, [hli]
    ld [wCurMapHeight], a
    ld a, l
    ld [wMapDataPtr], a
    ld a, h
    ld [wMapDataPtr+1], a
    call LoadTileBlockMap
    	;call LoadMapData
    jp SwitchToSRA2

;WRAMUncompressSpriteFromDE:
;    call UncompressSpriteFromDE
;    jp SwitchToSRA2

;WRAMLoadUncompressedSpriteData:
;    call LoadUncompressedSpriteData
;    jp SwitchToSRA2

WRAMCall_SRA3:
    call SwitchToSRA3
WRAMCall:
	;    ld a, e
	;    ld [wcd6d], a
	;    ld a, d
	;    ld [wcd6d+1], a
	;    ld de, SwitchToSRA2
	;    push de
	;    ld a, [wcd6d]
	;    ld e, a
	;    ld a, [wcd6d+1]
	;    ld d, a
	;    ld a, l
	;    ld [wWRAMCallJumpAddr], a
	;    ld a, h
	;    ld [wWRAMCallJumpAddr+1], a
	;    ld a, [wcd6d]
	;    ld l, a
	;    ld a, [wcd6d+1]
	;    ld h, a
    db $CD	; call
wWRAMCallJumpAddr
    ds 2
    jp SwitchToSRA2
;WRAMDecompressAndScaleSpriteByTwo:
    	;xor a
    	;call SwitchToSRAX
;    call UncompressSpriteFromDE
;    predef ScaleSpriteByTwo
;    ld de, $9310 ; vBackPic
;    call InterlaceMergeSpriteBuffers
;    jp SwitchToSRA2



	;CompressedPicBuffer:   ; use wTileMapBackup instead
	;    ds $110

	;MusicBuffer:	; use wOverworldMap instead